#!/bin/sh

VER=0.3.14
TARGET=scrollkeeper-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

. ../_blfsset.sh
. ../Xorg/_xorgset.sh
. ../gnome/_gnomeset.sh

cd $SRC

rm -fr $TARGETDIR

. $WRK/_extract.sh $GNOMEDLD/$TARGETBALL

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --localstatedir=/var \
            --disable-static \
            --with-omfdirs=/usr/share/omf \
	1> $LOG/$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1

echo \ \ Installing...
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

