#!/bin/sh

. ../_blfsset.sh
. ../Xorg/_xorgset.sh
. ./_gnomeset.sh

APPNAME=polkit-gnome
VER=0.105
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh gtk+-3 polkit
. $WRK/_checkOptions.sh  gtk-doc
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
    --libexecdir=/usr/lib/polkit-gnome \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

mkdir -p /etc/xdg/autostart
cat > /etc/xdg/autostart/polkit-gnome-authentication-agent-1.desktop << "EOF"
[Desktop Entry]
Name=PolicyKit Authentication Agent
Comment=PolicyKit Authentication Agent
Exec=/usr/lib/polkit-gnome/polkit-gnome-authentication-agent-1
Terminal=false
Type=Application
Categories=
NoDisplay=true
OnlyShowIn=GNOME;XFCE;Unity;
AutostartCondition=GNOME3 unless-session gnome
EOF
paco -p+ $TARGET "\
touch /etc/xdg/autostart/polkit-gnome-authentication-agent-1.desktop"

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

