#!/bin/sh

. ../_blfsset.sh
. ../Xorg/_xorgset.sh
. ./_gnomeset.sh

APPNAME=evolution-data-server
VER=3.6.4
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	db gnome-online-accounts \
        gperf libgdata libical nss
. $WRK/_checkOptions.sh  \
	libgweather gobject-introspection vala \
        gtk-doc krb5 sendmail openldap
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo \ \ Patching \(unofficial\)...
#patch -Np1 -i $WRK/patch/evolution-data-server-2.31.6.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
            --libexecdir=/usr/lib/evolution-data-server \
	$([ ${OPTION_vala} -eq 1 ] && echo --enable-vala-bindings) \
	$([ ${OPTION_openldap} -eq 1 ] && echo --with-openldap) \
	$([ ${OPTION_libgweather} -ne 1 ] && echo --without-weather) \
	$([ ${OPTION_krb5} -eq 1 ] && echo --with-krb5=/usr) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

