#!/bin/sh

. ./_blfsset.sh

APPNAME=avahi
VER=0.6.31
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	intltool pkg-config
. $WRK/_checkOptions.sh  \
	dbus-python gobject-introspection \
        gtk+-2 gtk+-3 libglade python-2 \
        libdaemon qt-4 dbus 
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_libdaemon} -eq "1" ]; then
  export DISABLELIBDAEMON=""
else
  export DISABLELIBDAEMON="--disable-libdaemon "
fi

unset MAKEFLAGS

cd $SRC 
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

groupadd -fg 84 avahi &&
useradd -c "Avahi Daemon Owner" -d /dev/null -u 84 \
    -g avahi -s /bin/false avahi  || [ $? == 9 ]
groupadd -fg 86 netdev

echo Patching from ML...
patch -Np1 -i $DLD/avahi-0.6.31-gtksymbols-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

echo Autoconfing...
autoreconf -fi \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr        \
            --sysconfdir=/etc    \
            --localstatedir=/var \
            --disable-static     \
            --disable-mono       \
            --disable-monodoc    \
            --disable-qt3        \
            --enable-core-docs   \
            --with-distro=none   \
            --disable-python     \
	    $([ ${OPTION_dbus} -ne "1" ] && echo --disable-dbus) \
	    $([ ${OPTION_libdaemon} -ne "1" ] && echo --disable-libdaemon) \
	    $([ ${OPTION_qt4} -ne "1" ] && echo --disable-qt4) \
	    $([ ${OPTION_gtk2} -ne "1" ] && echo --disable-gtk) \
	    $([ ${OPTION_gtk3} -ne "1" ] && echo --disable-gtk3) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

