#!/bin/sh

. ./_blfsset.sh

VER=1.8.4
JUNITVER=4.10
TARGET=apache-ant-$VER
TARGETBALL=${TARGET}-src.tar.bz2
TARGETDIR=$TARGET

echo Check Required...
./_checkRequired.sh jdk || exit 1

echo Check Options...
. ./_checkOptions.sh junit

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

sed -i 's;jars,test-jar;jars;' build.xml

cp -v /usr/share/junit-$JUNITVER/junit-$JUNITVER.jar \
      lib/optional/junit.jar

paco -p $TARGET "\
./build.sh -Ddist.dir=/opt/ant-$VER dist &&
ln -v -sf ant-$VER /opt/ant" \
	1> $LOG/$TARGET.1_build.log 2>&1 || exit 1

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

