#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=xterm
VER=312
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tgz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i '/v0/,+1s/new:/new:kb=^?:/' termcap 
echo -e '\tkbs=\\177,' >>terminfo

#    --enable-luit --enable-wide-chars \
Configuring
TERMINFO=/usr/share/terminfo ./configure $XORG_CONFIG \
    --with-app-defaults=/etc/X11/app-defaults \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET 'make install' \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET 'make install-ti'
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
cat >> /etc/X11/app-defaults/XTerm << "EOF"
*VT100*locale: true
*VT100*faceName: Monospace
*VT100*faceSize: 10
*backarrowKeyIsErase: true
*ptyInitialErase: true
EOF
"
TimeEnd

cd ..
RemoveSrcDir
PacoingDone

