#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=xorg-server
VER=1.16.1
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	openssl pixman xkeyboard-config
. $WRK/_checkOptions.sh  \
	libepoxy acpid doxygen fop gs xmlto
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
#patch -Np1 -i $XORGDLD/xorg-server-$VER-upstream_glamor_fix-1.patch \
#	1>  $LOG/$TARGET.0_patch.log 2>&1 || exit 1
patch -Np1 -i $XORGDLD/xorg-server-$VER-add_prime_support-1.patch \
	1>>  $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure $XORG_CONFIG                    \
           --with-xkb-output=/var/lib/xkb   \
           --enable-dmx                     \
           --enable-glamor                  \
           --enable-install-setuid          \
           --enable-suid-wrapper            \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mkdir -p /etc/X11/xorg.conf.d"

cat >> /etc/sysconfig/createfiles << "EOF"
/tmp/.ICE-unix dir 1777 root root
/tmp/.X11-unix dir 1777 root root
EOF
paco -p+ $TARGET "\
touch /etc/sysconfig/createfiles"

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

