#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=xcb-proto
VER=1.11
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh python-2
. $WRK/_checkOptions.sh  \
	libxml2 python-3
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#if [ ${OPTION_python3} -eq 1 ]; then
#  Patching
#  patch -Np1 -i $XORGDLD/xcb-proto-$VER-py_compile_python3-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
#  sed -i -e 's/\t/    /' xcbgen/xtypes.py
#fi

Configuring
./configure $XORG_CONFIG \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

