#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=MesaLib
VER=10.3.5
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.bz2
TARGETDIR=Mesa-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	Xorg-lib-libX11 libdrm python-2
. $WRK/_checkOptions.sh  \
	elfutils libvdpau \
	lesstif llvm
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_llvm} -eq "1" ]; then
  export ENABLELLVM="--enable-gallium-llvm "
  export GALLIUMDRIVERS="nouveau,r300,r600,radeonsi,svga,swrast"
else
  export ENABLELLVM=""
  export GALLIUMDRIVERS="nouveau,r600,svga,swrast"
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $XORGDLD/MesaLib-$VER-add_xdemos-1.patch \
	1>  $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./autogen.sh CFLAGS="-O2" CXXFLAGS="-O2"   \
            --prefix=$XORG_PREFIX          \
            --sysconfdir=/etc              \
            --enable-texture-float         \
            --enable-gles1                 \
            --enable-gles2                 \
            --enable-openvg                \
            --enable-osmesa                \
            --enable-xa                    \
            --enable-gbm                   \
            --enable-gallium-egl           \
            --enable-gallium-gbm           \
            --enable-glx-tls               \
            --with-egl-platforms="drm,x11" \
            --with-gallium-drivers="$GALLIUMDRIVERS" \
	    $ENABLELLVM \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || \
	(echo Failed to install && exit 1)

#install -v -dm755 /usr/share/doc/MesaLib-$VER
#paco -p+ $TARGET "\
#cp -rfv docs/* \
#                    /usr/share/doc/MesaLib-$VER" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || \
#	echo Failed to install docs

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

