#!/bin/sh

. ./_blfsset.sh

APPNAME=cdparanoia-III
VER=10.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.src.tgz
TARGETDIR=$TARGET

unset MAKEFLAGS

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/cdparanoia-III-$VER-gcc_fixes-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chmod -v 755 /usr/lib/libcdda_*.so.0.10.2

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

