#/bin/sh

. ./_cblfsset.sh

APPNAME=openssh
VER=6.1p1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

checkRequired ""
checkOptions  ""
checkTarball
checkExit "$1" || exit $?

groupadd -g 48 sshd
useradd -c 'sshd PrivSep' -d /var/lib/sshd -g sshd -s /bin/false -u 48 sshd
install -v -m700 -d /var/lib/sshd
chown -v root:sys /var/lib/sshd

cd $SRC

BIT64
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD64}" ./configure --prefix=/usr --sysconfdir=/etc/ssh \
    --libexecdir=/usr/sbin --with-md5-passwords \
    --with-privsep-path=/var/lib/sshd \
    --with-superuser-path="/sbin:/bin:/usr/sbin:/usr/bin" \
        1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m755 -d /usr/share/doc/openssh-$VER" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -m644 INSTALL LICENCE OVERVIEW README* \
/usr/share/doc/openssh-$VER" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..
RemoveSrcDir
PacoingDone

