#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=2.4.46
TARGET=attr-$VER
TARGETBALL=$TARGET.src.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

sed -i -e 's|/@pkg_name@|&-@pkg_version@|' include/builddefs.in

echo \ \ Configuring...
./configure --prefix=/usr --libdir=/lib --libexecdir=/usr/lib \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "\
make install install-dev install-lib" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

chmod -v 0755 /lib/libattr.so.1.1.0

paco -p+ $TARGET "\
rm -v /lib/libattr.{a,la,so}"
paco -p+ $TARGET "\
sed -i 's@/lib@/usr/lib@' /usr/lib/libattr.la && \
ln -sfv ../../lib/libattr.so.1 /usr/lib/libattr.so"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

