#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=2.23.1
TARGET=binutils-$VER
TARGETBALL=${TARGET}.tar.bz2
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR
rm -fr binutils-build

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

rm -fv etc/standards.info
sed -i.bak '/^INFO/s/standards.info //' etc/Makefile.in

#sed -i "/exception_defines.h/d" ld/testsuite/ld-elf/new.cc
#sed -i "s/-fvtable-gc //" ld/testsuite/ld-selective/selective.exp

mkdir -v ../binutils-build
cd ../binutils-build

echo \ \ Configuring...
../binutils-$VER/configure --prefix=/usr \
    --enable-shared \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make tooldir=/usr \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make tooldir=/usr install" \
	1> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
cp -v ../binutils-$VER/include/libiberty.h /usr/include"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR && rm -fr binutils-build

echo \ \ Done.

