#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

TARGET=strip

echo $CHAP: $TARGET

. ./_lfsset.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

strip --strip-debug /tools/lib/* \
	1> $LOG/$CHAP.$TARGET.1_strip.log 2>&1

strip --strip-unneeded /tools/{,s}bin/* \
	1> $LOG/$CHAP.$TARGET.2_strip.log 2>&1

rm -rf /tools/{,share}/{info,man} \
	1> $LOG/$CHAP.$TARGET.3_strip.log 2>&1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo Done.

