#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=4.7.2
TARGET=gcc-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

VER_mpfr=3.1.1
VER_gmp=5.1.0
VER_mpc=1.0.1

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR
rm -fr gcc-build

. $WRK/_extract.sh

cd $TARGETDIR

tar -Jxf $DLD/mpfr-$VER_mpfr.tar.xz || exit 1
mv -v mpfr-$VER_mpfr mpfr
tar -Jxf $DLD/gmp-$VER_gmp.tar.xz || exit 1
mv -v gmp-$VER_gmp gmp
tar -zxf $DLD/mpc-$VER_mpc.tar.gz || exit 1
mv -v mpc-$VER_mpc mpc


START=`date +'%Y/%m/%d %H:%M:%S.%N'`

for file in \
 $(find gcc/config -name linux64.h -o -name linux.h -o -name sysv4.h)
do
  cp -uv $file{,.orig}
  sed -e 's@/lib\(64\)\?\(32\)\?/ld@/tools&@g' \
      -e 's@/usr@/tools@g' $file.orig > $file
  echo '
#undef STANDARD_STARTFILE_PREFIX_1
#undef STANDARD_STARTFILE_PREFIX_2
#define STANDARD_STARTFILE_PREFIX_1 "/tools/lib/"
#define STANDARD_STARTFILE_PREFIX_2 ""' >> $file
  touch $file.orig
done

sed -i '/k prot/agcc_cv_libc_provides_ssp=yes' gcc/configure

mkdir -v ../gcc-build
cd ../gcc-build

echo \ \ Configuring...
../gcc-$VER/configure         \
    --target=$LFS_TGT          \
    --prefix=/tools            \
    --with-sysroot=$LFS        \
    --with-newlib              \
    --without-headers          \
    --with-local-prefix=/tools \
    --with-native-system-header-dir=/tools/include \
    --disable-nls              \
    --disable-shared           \
    --disable-multilib         \
    --disable-decimal-float    \
    --disable-threads          \
    --disable-libmudflap       \
    --disable-libssp           \
    --disable-libgomp          \
    --disable-libquadmath      \
    --enable-languages=c       \
    --with-mpfr-include=$(pwd)/../gcc-$VER/mpfr/src \
    --with-mpfr-lib=$(pwd)/mpfr/src/.libs \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
ln -vs libgcc.a `$LFS_TGT-gcc -print-libgcc-file-name | sed 's/libgcc/&_eh/'`

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo Removing directory...
cd .. && rm -fr $TARGETDIR && rm -fr gcc-build

echo \ \ Done.

