#/bin/sh

CHAP=7all

. ./_lfsset.sh

VER=${BOOTSCRIPTVER}
TARGET=lfs-bootscripts-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo 7.2

cat > /etc/systemd/network/10-eth-dhcp.network << "EOF"
[Match]
Name=eth0

[Network]
DHCP=ipv4

[DHCP]
UseDomains=true
EOF

echo 7.2.2.1 systemd-resolved

ln -sfv /run/systemd/resolve/resolv.conf /etc/resolv.conf

echo 7.2.3
if [ $(uname -m) = i686 ]; then
echo "LFS32sysd" > /etc/hostname
else
echo "LFS64sysd" > /etc/hostname
fi

echo 7.5.4
if [ $(uname -m) = i686 ]; then
cat > /etc/hosts << "EOF"
# Begin /etc/hosts

127.0.0.1 localhost LFS32sysd

# End /etc/hosts (network card version)
EOF
else
cat > /etc/hosts << "EOF"
# Begin /etc/hosts

127.0.0.1 localhost LFS64sysd

# End /etc/hosts
EOF
fi

echo 7.5

cat > /etc/adjtime << "EOF"
0.0 0 0.0
0
LOCAL
EOF

echo 7.6.4

echo 7.6.5

cat > /etc/vconsole.conf << "EOF"
KEYMAP="jp106"
FONT=""
EOF

echo 7.7

cat > /etc/locale.conf << "EOF"
LANG=ja_JP.UTF-8
EOF

echo 7.8

cat > /etc/inputrc << "EOF"
# Begin /etc/inputrc
# Modified by Chris Lynn <roryo@roryo.dynup.net>

# Allow the command prompt to wrap to the next line
set horizontal-scroll-mode Off

# Enable 8bit input
set meta-flag On
set input-meta On

# Turns off 8th bit stripping
set convert-meta Off

# Keep the 8th bit for display
set output-meta On

# none, visible or audible
set bell-style none

# All of the following map the escape sequence of the value
# contained in the 1st argument to the readline specific functions
"\eOd": backward-word
"\eOc": forward-word

# for linux console
"\e[1~": beginning-of-line
"\e[4~": end-of-line
"\e[5~": beginning-of-history
"\e[6~": end-of-history
"\e[3~": delete-char
"\e[2~": quoted-insert

# for xterm
"\eOH": beginning-of-line
"\eOF": end-of-line

# for Konsole
"\e[H": beginning-of-line
"\e[F": end-of-line

# End /etc/inputrc
EOF

echo 7.9

cat > /etc/shells << "EOF"
# Begin /etc/shells

/bin/sh
/bin/bash

# End /etc/shells
EOF

mkdir -pv /etc/systemd/system/getty@tty1.service.d

cat > /etc/systemd/system/getty@tty1.service.d/noclear.conf << EOF
[Service]
TTYVTDisallocate=no
EOF

ln -sfv /dev/null /etc/systemd/system/tmp.mount
