#/bin/sh

CHAP=6
APPNAME=python
VER=3.7.0
TARGET=$APPNAME-$VER
TARGETBALL=Python-$VER.tar.xz
TARGETDIR=Python-$VER

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr       \
            --enable-shared     \
            --with-system-expat \
            --with-system-ffi   \
            --with-ensurepip=yes \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
chmod -v 755 /usr/lib/libpython3.6m.so
chmod -v 755 /usr/lib/libpython3.so

#echo \ \ Installing docs...
#install -v -dm755 /usr/share/doc/python-$VER/html
#porg -lp+ $TARGET "\
#tar --strip-components=1  \
#    --no-same-owner       \
#    --no-same-permissions \
#    -C /usr/share/doc/python-$VER/html \
#    -xvf ../python-$VER-docs-html.tar.bz2" \
#	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
