#/bin/sh

CHAP=6
APPNAME=sysklogd
VER=1.5.1
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

sed -i '/Error loading kernel symbols/{n;n;d}' ksym_mod.c
sed -i 's/union wait/int/' syslogd.c

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.1_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "make BINDIR=/sbin install" \
	1> $LOG/$CHAP.$TARGET.2_install.log 2>&1 || exit 1

cat > /etc/syslog.conf << "EOF"
# Begin /etc/syslog.conf

auth,authpriv.* -/var/log/auth.log
*.*;auth,authpriv.none -/var/log/sys.log
daemon.* -/var/log/daemon.log
kern.* -/var/log/kern.log
mail.* -/var/log/mail.log
user.* -/var/log/user.log
*.emerg *

# End /etc/syslog.conf
EOF
porg -lp+ $TARGET "touch /etc/syslog.conf"

TimeEnd chap6

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
