#/bin/sh

CHAP=6
APPNAME=sed
VER=4.5
TARGET=sed-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

sed -i 's/usr/tools/'                 build-aux/help2man
sed -i 's/testsuite.panic-tests.sh//' Makefile.in

echo \ \ Configuring...
./configure --prefix=/usr --bindir=/bin \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
#make html \
#	1>> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install -d -m755           /usr/share/doc/sed-$VER" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
#porg -lp+ $TARGET "\
#install -m644 doc/sed.html /usr/share/doc/sed-$VER" \
#	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Done.
