#/bin/sh

CHAP=6
APPNAME=openssl
VER=1.1.0i
TARGET=$APPNAME-$VER
TARGETBALL=$APPNAME-$VER.tar.gz
TARGETDIR=$APPNAME-$VER

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./config --prefix=/usr         \
         --openssldir=/etc/ssl \
         --libdir=lib          \
         shared                \
         zlib-dynamic          \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
sed -i '/INSTALL_LIBS/s/libcrypto.a libssl.a//' Makefile
porg -lp $TARGET "\
make MANSUFFIX=ssl install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
