#/bin/sh

. ./_clfsset.sh

APPNAME=gcc
VER=4.8.3
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

cd $SRC

RemoveSrcDir
rm -fr gcc-build

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

echo Patching...
patch -Np1 -i $DLD/gcc-$VER-branch_update-1.patch \
        1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/gcc-$VER-specs-1.patch \
        1>> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo -en '\n#undef STANDARD_STARTFILE_PREFIX_1\n#define STANDARD_STARTFILE_PREFIX_1 "/tools/lib/"\n' >> gcc/config/linux.h
echo -en '\n#undef STANDARD_STARTFILE_PREFIX_2\n#define STANDARD_STARTFILE_PREFIX_2 ""\n' >> gcc/config/linux.h

touch /tools/include/limits.h

mkdir ../gcc-build
cd ../gcc-build

echo Configuring...
AR=ar LDFLAGS="-Wl,-rpath,/cross-tools/lib" \
    ../gcc-$VER/configure --prefix=/cross-tools \
    --build=${CLFS_HOST} --host=${CLFS_HOST} --target=${CLFS_TARGET} \
    --with-sysroot=${CLFS} --with-local-prefix=/tools \
    --with-native-system-header-dir=/tools/include --disable-nls \
    --disable-shared --with-mpfr=/cross-tools --with-gmp=/cross-tools \
    --with-cloog=/cross-tools --with-mpc=/cross-tools --without-headers \
    --with-newlib --disable-decimal-float --disable-libgomp --disable-libmudflap \
    --disable-libssp --disable-libatomic --disable-libitm \
    --disable-libsanitizer --disable-libquadmath --disable-threads \
    --disable-target-zlib --with-system-zlib --with-isl=/cross-tools \
    --enable-languages=c --enable-checking=release \
        1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make all-gcc all-target-libgcc \
        1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install-gcc install-target-libgcc \
        1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
rm -fr gcc-build

echo Done.

