#/bin/sh

. ./_clfsset.sh

APPNAME=linux
VER=$LINUX_VER
TARGET=$APPNAME-$LINUX_VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

#echo Patching...
#xzcat $DLD/patch-3.14.21.xz | patch -Np1 -i - \
#        1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo Configuring...
make mrproper \
        1> $LOG/$THISFILE.1_mrproper.log 2>&1 || exit 1

make defconfig
make menuconfig

echo Making...
make \
        1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make modules_install \
        1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
make firmware_install \
        1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

cp -v arch/x86_64/boot/bzImage /boot/vmlinuz-clfs-$LINUX_VER \
        1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
cp -v System.map /boot/System.map-$LINUX_VER \
        1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
cp -v .config /boot/config-$LINUX_VER \
        1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
