#/bin/sh

. ./_clfsset.sh

APPNAME=shadow
VER=4.2.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

sed -i src/Makefile.in \
  -e 's/groups$(EXEEXT) //' -e 's/= nologin$(EXEEXT)/= /'
find man -name Makefile.in -exec sed -i \
  -e 's/man1\/groups\.1 //' -e 's/man8\/nologin\.8 //' '{}' \;

echo Configuring...
CC="gcc ${BUILD64}" ./configure --sysconfdir=/etc \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

sed -i /etc/login.defs \
    -e 's@#\(ENCRYPT_METHOD \).*@\1SHA512@' \
    -e 's@/var/spool/mail@/var/mail@'

mv -v /usr/bin/passwd /bin \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

touch /var/log/lastlog
chgrp -v utmp /var/log/lastlog \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
chmod -v 664 /var/log/lastlog \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

pwconv
grpconv

TimeEnd

passwd root

cd ..
RemoveSrcDir

echo Done.
