#/bin/sh

. ./_clfsset.sh

APPNAME=pkg-config-lite
VER=0.28-1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD64}" ./configure --prefix=/usr \
    --docdir=/usr/share/doc/pkg-config-0.28-1 --with-pc-path=/usr/share/pkgconfig \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

export PKG_CONFIG_PATH32="/usr/lib/pkgconfig"
export PKG_CONFIG_PATH64="/usr/lib64/pkgconfig"

cat >> /root/.bash_profile << EOF
export PKG_CONFIG_PATH32="${PKG_CONFIG_PATH32}"
export PKG_CONFIG_PATH64="${PKG_CONFIG_PATH64}"
EOF

TimeEnd

cd ..
RemoveSrcDir

echo Done.
