#/bin/sh

. ./_clfsset.sh

APPNAME=ncurses
VER=5.9
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/ncurses-$VER-branch_update-4.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo Configuring...
CC="gcc ${BUILD64}" CXX="g++ ${BUILD64}" \
   ./configure --prefix=/usr --libdir=/lib64 \
   --with-shared --without-debug --enable-widec \
   --with-manpage-format=normal --enable-pc-files \
   --with-default-terminfo-dir=/usr/share/terminfo \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

mv -v /usr/bin/ncursesw5-config{,-64} \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -svf multiarch_wrapper /usr/bin/ncursesw5-config \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

mv -v /lib64/lib{panelw,menuw,formw,ncursesw,ncurses++w}.a /usr/lib64 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

ln -svf ../../lib64/$(readlink /lib64/libncursesw.so) /usr/lib64/libncursesw.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -svf ../../lib64/$(readlink /lib64/libmenuw.so) /usr/lib64/libmenuw.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -svf ../../lib64/$(readlink /lib64/libpanelw.so) /usr/lib64/libpanelw.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -svf ../../lib64/$(readlink /lib64/libformw.so) /usr/lib64/libformw.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
rm -v /lib64/lib{ncursesw,menuw,panelw,formw}.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

for lib in curses ncurses form panel menu ; do
        echo "INPUT(-l${lib}w)" > /usr/lib64/lib${lib}.so
        ln -sfv lib${lib}w.a /usr/lib64/lib${lib}.a \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
done

ln -sfv libcurses.so /usr/lib64/libcursesw.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sfv libncurses.so /usr/lib64/libcurses.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sfv libncursesw.a /usr/lib64/libcursesw.a \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sfv libncurses.a /usr/lib64/libcurses.a \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sfv libncurses++w.a /usr/lib64/libncurses++.a \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sfv ncursesw5-config-64 /usr/bin/ncurses5-config-64 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sfv ncursesw5-config /usr/bin/ncurses5-config \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
