#/bin/sh

. ./_clfsset.sh

APPNAME=kmod
VER=18
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
PKG_CONFIG_PATH=${PKG_CONFIG_PATH64} CC="gcc ${BUILD64}" \
  ./configure --prefix=/usr \
    --bindir=/bin --sysconfdir=/etc \
    --with-rootlibdir=/lib64 --libdir=/usr/lib64 \
    --with-zlib --with-xz \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

ln -sfv kmod /bin/lsmod \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
for tool in depmod insmod modinfo modprobe rmmod; do
    ln -sfv ../bin/kmod /sbin/${tool} \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
done

TimeEnd

cd ..
RemoveSrcDir

echo Done.
