#/bin/sh

. ./_clfsset.sh

APPNAME=glibc
VER=2.19
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
rm -fr glibc-build

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

LINKER=$(readelf -l /tools/bin/bash | sed -n 's@.*interpret.*/tools\(.*\)]$@\1@p')
sed -i "s|libs -o|libs -L/usr/lib -Wl,-dynamic-linker=${LINKER} -o|" \
  scripts/test-installation.pl
unset LINKER

sed -i 's/\\$$(pwd)/`pwd`/' timezone/Makefile

mkdir -p ../glibc-build
cd ../glibc-build

echo Configuring...
CC="gcc ${BUILD32}" CXX="g++ ${BUILD32}" \
    ../glibc-2.19/configure --prefix=/usr \
    --disable-profile --enable-kernel=2.6.32 \
    --libexecdir=/usr/lib/glibc --host=${CLFS_TARGET32} \
    --enable-obsolete-rpc \
        1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

#echo Testing...
#make -k check 2>&1 \
#        1> $LOG/$THISFILE.2_test.log 2>&1 || (echo Error occured in tests)

touch /etc/ld.so.conf

echo Installing...
make install \
        1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
rm -v /usr/include/rpcsvc/*.x \
        1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
rm -fr glibc-build

echo Done.

