#/bin/sh

. ./_clfsset.sh

APPNAME=coreutils
VER=8.22
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/coreutils-$VER-uname-1.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo Configuring...
FORCE_UNSAFE_CONFIGURE=1 CC="gcc ${BUILD64}" \
   ./configure --prefix=/usr \
    --enable-no-install-program=kill,uptime \
    --enable-install-program=hostname \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /usr/bin/{cat,chgrp,chmod,chown,cp,date} /bin \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /usr/bin/{dd,df,echo,false,hostname,ln,ls,mkdir,mknod} /bin \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /usr/bin/{pwd,rm,rmdir,stty,true,uname} /bin \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /usr/bin/chroot /usr/sbin \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
