#/bin/sh

. ./_clfsset.sh

APPNAME=bash
VER=4.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/bash-$VER-branch_update-5.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

sed -i "/ac_cv_rl_libdir/s@/lib@&64@" configure

echo Configuring...
CC="gcc ${BUILD64}" CXX="g++ ${BUILD64}" \
    ./configure --prefix=/usr --bindir=/bin \
    --without-bash-malloc --with-installed-readline \
    --docdir=/usr/share/doc/bash-$VER \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
exec /bin/bash --login +h
exec /bin/bash --login +h

