#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=0.12.1
TARGET=ppl-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CPPFLAGS=-fexceptions CC="gcc -isystem /usr/include ${BUILD64}" \
CXX="g++ -isystem /usr/include ${BUILD64}" \
LDFLAGS="-Wl,-rpath-link,/usr/lib64:/lib64 ${BUILD64}" \
  ./configure --prefix=/usr --libdir=/usr/lib64 \
    --enable-shared --disable-optimization \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/bin/ppl-config{,-64}" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -svf multiarch_wrapper /usr/bin/ppl-config" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/include/ppl{,-64}.hh" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

cat > /usr/include/ppl.hh << "EOF"
/* ppl.hh - Stub Header  */
#ifndef __STUB__PPL_HH__
#define __STUB__PPL_HH__

#if defined(__x86_64__) || \
    defined(__sparc64__) || \
    defined(__arch64__) || \
    defined(__powerpc64__) || \
    defined (__s390x__)
# include "ppl-64.h"
#else
# include "ppl-32.h"
#endif

#endif /* __STUB__PPL_HH__ */
EOF
paco -p+ $TARGET "touch /usr/include/ppl.hh" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
TimeEnd

cd ..
RemoveSrcDir
PacoingDone
