#/bin/sh

. ./_cblfsset.sh

APPNAME=libgcrypt
VER=1.5.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

checkRequired \
	libgpg-error
checkOptions  \
	pth
checkTarball
checkExit "$1" || exit $?

cd $SRC

BIT32
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD32}" \
CC="gcc ${BUILD32}" USE_ARCH=32 ./configure --prefix=/usr \
    --build=$CLFS_TARGET32 --host=$CLFS_TARGET32 \
	1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/bin/libgcrypt-config{,-32}" \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..

BIT64
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD64}" USE_ARCH=64 ./configure --prefix=/usr \
    --libdir=/usr/lib64 \
        1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p+ $TARGET "\
make install" \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/bin/libgcrypt-config{,-64}" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv multiarch_wrapper /usr/bin/libgcrypt-config" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..
RemoveSrcDir
PacoingDone

