#!/bin/sh

. ./_cblfsset.sh

APPNAME=bash-completion
VER=20060301
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=bash_completion

echo $TARGET

cd $SRC
RemoveSrcDir
Extract

cd $TARGETDIR

echo Patching unofficial...
patch -Np1 -i $WRKBLFS/patch/bash-completion-$VER.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

paco -p $TARGET "\
install -m644 bash_completion.sh /etc/profile.d/70-bash_completion.sh"

paco -p+ $TARGET "\
cp -v bash_completion /etc"

paco -p+ $TARGET "\
install -d /etc/bash_completion.d"

paco -p+ $TARGET "\
install -d /usr/share/bash-completion"

paco -p+ $TARGET "\
cp -v contrib/* /usr/share/bash-completion"

paco -p+ $TARGET "\
install -d /usr/share/doc/bash-completion"

paco -p+ $TARGET "\
cp -v README /usr/share/doc/bash-completion"

cat >> /etc/bashrc << "EOF"
# Enable bash completion
if [ -f /etc/bash_completion ]; then
  source /etc/bash_completion
fi
EOF

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

