#!/bin/sh

. ./_blfsset.sh

APPNAME=xvid
VER=1.3.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/xvidcore-$VER.tar.gz
TARGETDIR=xvidcore

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	yasm
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

cd build/generic

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chmod -v 755 /usr/lib/libxvidcore.so.4.3 \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -v -sf libxvidcore.so.4.3 /usr/lib/libxvidcore.so.4" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -v -sf libxvidcore.so.4   /usr/lib/libxvidcore.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m755 -d /usr/share/doc/xvidcore-1.3.2/examples" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -m644 ../../doc/* /usr/share/doc/xvidcore-1.3.2" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -m644 ../../examples/* \
    /usr/share/doc/xvidcore-1.3.2/examples" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../../..
RemoveSrcDir
PacoingDone

