#!/bin/sh

. ./_blfsset.sh

APPNAME=xinetd
VER=2.3.15
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo Check Required...
./_checkRequired.sh libtirpc || exit 1

echo Check Options...
. ./_checkOptions.sh tcp_wrappers

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

sed -i -e "/^LIBS/s/-lpset/& -ltirpc/" xinetd/Makefile.in
sed -i -e "/register unsigned count/s/register//" xinetd/itox.c

echo \ \ Configuring...
./configure --prefix=/usr --with-loadavg \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1


cat > /etc/xinetd.conf << "EOF"
# Begin /etc/xinetd
# Configuration file for xinetd

defaults
{
      instances       = 60
      log_type        = SYSLOG daemon
      log_on_success  = HOST PID USERID
      log_on_failure  = HOST USERID
      cps             = 25 30
}

# All service files are stored in the /etc/xinetd.d directory

includedir /etc/xinetd.d

# End /etc/xinetd
EOF

paco -p+ $TARGET "touch /etc/xinetd.conf"

install -v -d -m755 /etc/xinetd.d

cat > /etc/xinetd.d/systat << "EOF" &&
# Begin /etc/xinetd.d/systat

service systat
{
   disable           = yes
   socket_type       = stream
   wait              = no
   user              = nobody
   server            = /usr/bin/ps
   server_args       = -auwwx
   only_from         = 128.138.209.0
   log_on_success    = HOST
}

# End /etc/xinetd.d/systat
EOF
paco -p+ $TARGET "touch /etc/xinetd.d/systat"

cat > /etc/xinetd.d/echo << "EOF" &&
# Begin /etc/xinetd.d/echo

service echo
{
   disable     = yes
   type        = INTERNAL
   id          = echo-stream
   socket_type = stream
   protocol    = tcp
   user        = root
   wait        = no
}

service echo
{
   disable     = yes
   type        = INTERNAL
   id          = echo-dgram
   socket_type = dgram
   protocol    = udp
   user        = root
   wait        = yes
}

# End /etc/xinetd.d/echo
EOF

paco -p+ $TARGET "touch /etc/xinetd.d/echo"

cat > /etc/xinetd.d/chargen << "EOF" &&
# Begin /etc/xinetd.d/chargen

service chargen
{
   disable        = yes
   type           = INTERNAL
   id             = chargen-stream
   socket_type    = stream
   protocol       = tcp
   user           = root
   wait           = no
}

service chargen
{
   disable        = yes
   type           = INTERNAL
   id             = chargen-dgram
   socket_type    = dgram
   protocol       = udp
   user           = root
   wait           = yes
}

# End /etc/xinetd.d/chargen
EOF
paco -p+ $TARGET "touch /etc/xinetd.d/chargen"

cat > /etc/xinetd.d/daytime << "EOF" &&
# Begin /etc/xinetd.d/daytime

service daytime
{
   disable        = yes
   type           = INTERNAL
   id             = daytime-stream
   socket_type    = stream
   protocol       = tcp
   user           = root
   wait           = no
}

service daytime
{
   disable        = yes
   type           = INTERNAL
   id             = daytime-dgram
   socket_type    = dgram
   protocol       = udp
   user           = root
   wait           = yes
}

# End /etc/xinetd.d/daytime
EOF
paco -p+ $TARGET "touch /etc/xinetd.d/daytime"

cat > /etc/xinetd.d/time << "EOF" &&
# Begin /etc/xinetd.d/time

service time
{
   disable        = yes
   type           = INTERNAL
   id             = time-stream
   socket_type    = stream
   protocol       = tcp
   user           = root
   wait           = no
}

service time
{
   disable        = yes
   type           = INTERNAL
   id             = time-dgram
   socket_type    = dgram
   protocol       = udp
   user           = root
   wait           = yes
}

# End /etc/xinetd.d/time
EOF
paco -p+ $TARGET "touch /etc/xinetd.d/time"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

