#!/bin/sh

. ./_xfceset.sh

APPNAME=libunique
VER=1.1.6
TARGET=$APPNAME-$VER
TARGETBALL=$XFCEDLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	gtk+-2
. $WRK/_checkOptions.sh  \
	gobject-introspection gtk-doc
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $XFCEDLD/libunique-$VER-upstream_fixes-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

echo Autoconfing
autoreconf -fi \
	1> $LOG/$TARGET.1_auto.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
        --disable-dbus \
        --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

