#!/bin/sh

# http://sourceforge.net/projects/wine/files/Source/wine-1.1.39.tar.bz2/download

. ./_blfsset.sh

APPNAME=wine
VER=1.5.26
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	--enable-win64 \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make depend \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1
make \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

