#!/bin/sh

. ./_blfsset.sh

APPNAME=sudo
VER=1.8.25
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	openafs Linux-PAM krb5 sendmail openldap \
	opie secureid
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

export WITHPAM=""

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr         \
            --libexecdir=/usr/lib \
            --with-secure-path    \
            --with-all-insults    \
            --with-env-editor     \
            --docdir=/usr/share/doc/sudo-$VER \
            --with-passprompt="[sudo] password for %p" \
	$([ ${OPTION_LinuxPAM} -ne 1 ] && echo --without-pam) \
	$([ ${OPTION_sendmail} -ne "1" ] && echo --without-sendmail) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp  $TARGET "\
ln -sfv libsudo_util.so.0.0.0 /usr/lib/sudo/libsudo_util.so.0" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

if [ ${OPTION_LinuxPAM} -eq 1 ]; then
cat > /etc/pam.d/sudo << "EOF"
# Begin /etc/pam.d/sudo

# include the default auth settings
auth      include     system-auth

# include the default account settings
account   include     system-account

# Set default environment variables for the service user
session   required    pam_env.so

# include system session defaults
session   include     system-session

# End /etc/pam.d/sudo
EOF
chmod 644 /etc/pam.d/sudo
porg -lp+ $TARGET "touch /etc/pam.d/sudo"
fi

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

