#!/bin/sh

. ./_blfsset.sh

APPNAME=slim
VER=1.3.6
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	cmake \
	Xorg-lib-libX11 libpng libjpeg-turbo freetype
. $WRK/_checkOptions.sh  \
	Linux-PAM 
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo Patching unofficial...
#patch -Np1 -i $WRK/patch/slim-$VER.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

#sed -i -e "s:^MANDIR=.*:MANDIR=/usr/share/man:" \
#-e "s:/usr/X11R6:/usr:" \
#Makefile

sed -i -e 's#X11R6/##g' -e 's#/usr/bin:##' \
-e 's/# daemon/daemon/' \
slim.conf

mkdir -p build
cd build

echo CMaking...
cmake \
	-DCMAKE_INSTALL_PREFIX=/usr \
        -DCMAKE_BUILD_TYPE=Release  \
$([ ${OPTION_LinuxPAM} -eq 1 ] && echo -DUSE_PAM=yes) \
	.. \
	1> $LOG/$TARGET.1_cmake.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "\
make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cd ..
if [ ${OPTION_LinuxPAM} -eq 1 ]; then
  paco -p+ $TARGET "\
  cp -pv pam.sample /etc/pam.d/slim" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
fi

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

