#!/bin/sh

. ./_blfsset.sh

APPNAME=seamonkey
VER=2.22.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME-$VER.source.tar.bz2
TARGETDIR=$TARGET
TARGETDIR2=comm-release

echo $TARGET

. $WRK/_checkRequired.sh \
	alsa-lib gtk+-2 zip unzip
. $WRK/_checkOptions.sh  \
	yasm libvpx \
	dbus-glib startup-notification sqlite hunspell \
	libevent doxygen gnome-vfs libgnomeui libnotify \
	nspr nss wireless_tools valgrind wget
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir

TimeStart

mkdir -pv $TARGETDIR
cd $TARGETDIR
Extract

cd $TARGETDIR2

cat > mozconfig << "EOF"
# If you have a multicore machine you can speed up the build by running
# several jobs at once, but if you have a single core, delete this line:
# mk_add_options MOZ_MAKE_FLAGS="-j$(getconf _NPROCESSORS_ONLN)"

# If you have installed Yasm delete this option:
#ac_add_options --disable-webm

# If you have installed DBus-Glib delete this option:
#ac_add_options --disable-dbus

# If you have installed wireless-tools delete this option:
#ac_add_options --disable-necko-wifi

# If you have installed libnotify delete this option:
#ac_add_options --disable-libnotify

# Uncomment these if you have installed them:
# ac_add_options --enable-startup-notification
# ac_add_options --enable-system-hunspell
# ac_add_options --enable-system-sqlite
# ac_add_options --with-system-libevent
# ac_add_options --with-system-libvpx
# ac_add_options --with-system-nspr
# ac_add_options --with-system-nss

mk_add_options MOZ_OBJDIR=@TOPSRCDIR@/moz-build-dir
ac_add_options --disable-crashreporter
ac_add_options --disable-debug
ac_add_options --disable-debug-symbols
ac_add_options --disable-installer
ac_add_options --disable-static
ac_add_options --disable-tests
ac_add_options --disable-updater
ac_add_options --enable-application=suite
ac_add_options --enable-shared
ac_add_options --enable-system-ffi
ac_add_options --prefix=/usr
ac_add_options --with-pthreads
ac_add_options --with-system-jpeg
ac_add_options --with-system-png
ac_add_options --with-system-zlib
EOF

if [ ${OPTION_startupnotification} -eq 1 ]; then
  sed -i -e '/startup-notification/s/^# //' mozconfig
fi

if [ ${OPTION_hunspell} -eq 1 ]; then
  sed -i -e '/hunspell/s/^# //' mozconfig
fi

if [ ${OPTION_sqlite} -eq 1 ]; then
  sed -i -e '/sqlite/s/^# //' mozconfig
fi

if [ ${OPTION_libevent} -eq 1 ]; then
  sed -i -e '/libevent/s/^# //' mozconfig
fi

if [ ${OPTION_libvpx} -eq 1 ]; then
  sed -i -e '/libvpx/s/^# //' mozconfig
fi

if [ ${OPTION_nspr} -eq 1 ]; then
  sed -i -e '/nspr/s/^# //' mozconfig
fi

if [ ${OPTION_nss} -eq 1 ]; then
  sed -i -e '/nss/s/^# //' mozconfig
fi

Patching
patch -Np1 -i $DLD/seamonkey-$VER-freetype-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Making
make -f client.mk \
	1> $LOG/$TARGET.1_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "\
make -C moz-build-dir/suite/installer" \
	1> $LOG/$TARGET.2_install.log 2>&1 || exit 1

rm -rf    /usr/lib/seamonkey-$VER
mkdir -pv /usr/lib/seamonkey-$VER

tar -xf moz-build-dir/mozilla/dist/seamonkey-$VER.en-US.linux-$(uname -m).tar.bz2 \
  -C /usr/lib/seamonkey-$VER --strip-components=1

ln -sfv ../lib/seamonkey-$VER/seamonkey /usr/bin

mkdir -pv /usr/lib/mozilla/plugins
ln -sfv ../mozilla/plugins /usr/lib/seamonkey-$VER

cp -v moz-build-dir/mozilla/dist/man/man1/seamonkey.1 /usr/share/man/man1

paco -p+ $TARGET "\
make -C moz-build-dir install" \
	1>> $LOG/$TARGET.2_install.log 2>&1 || exit 1

echo -n Pacoing:\   && paco $TARGET || echo none

mkdir -pv /usr/share/{applications,pixmaps}

cat > /usr/share/applications/seamonkey.desktop << "EOF" &&
[Desktop Entry]
Encoding=UTF-8
Type=Application
Name=SeaMonkey
Comment=The Mozilla Suite
Icon=seamonkey
Exec=seamonkey
Categories=Network;GTK;Application;Email;Browser;WebBrowser;News;
StartupNotify=true
Terminal=false
EOF

ln -sfv /usr/lib/seamonkey-$VER/chrome/icons/default/seamonkey.png \
        /usr/share/pixmaps

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

