#!/bin/sh

. ./_blfsset.sh

APPNAME=screen
VER=4.6.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr                     \
            --infodir=/usr/share/info         \
            --mandir=/usr/share/man           \
            --with-socket-dir=/run/screen     \
            --with-pty-group=5                \
            --with-sys-screenrc=/etc/screenrc \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

sed -i -e "s%/usr/local/etc/screenrc%/etc/screenrc%" {etc,doc}/* 

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install && \
	install -m 644 etc/etcscreenrc /etc/screenrc" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo "cjkwidth off" >> /etc/screenrc

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

