#!/bin/sh

. ./_blfsset.sh

APPNAME=redis
VER=4.0.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

groupadd redis
useradd -g redis -s /bin/false redis

sed -i "/^PREFIX/s|/usr/local|/usr|" src/Makefile

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
mkdir -p /etc/redis
mkdir -p /var/lib/redis
chown redis:redis /var/lib/redis
chmod 770 /var/lib/redis
porg -lp+ $TARGET "\
cp redis.conf /etc/redis" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
sed -i 's/^supervised no/supervised systemd/' \
	/etc/redis/redis.conf
sed -i 's|^dir \./|dir /var/lib/redis|' \
	/etc/redis/redis.conf

cat > /lib/systemd/system/redis.service << "EOF"
[Unit]
Description=Redis In-Memory Data Store
After=network.target

[Service]
User=redis
Group=redis
ExecStart=/usr/bin/redis-server /etc/redis/redis.conf
ExecReload=/usr/bin/redis-cli shutdown
Restart=always

[Install]
WantedBy=multi-user.target
EOF
porg -lp+ $TARGET "\
touch /lib/systemd/system/redis.service" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

systemctl enable redis

cd ..
RemoveSrcDir
PorgingDone

