#!/bin/sh

. ./_blfsset.sh

APPNAME=qemu
VER=1.4.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	glib-2 python-2 SDL Xorg-lib-libX11
. $WRK/_checkOptions.sh  \
	alsa-lib attr check curl esound mesalib cyrus-sasl
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/qemu-$VER-fixes-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr                \
            --sysconfdir=/etc            \
            --target-list=x86_64-softmmu \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -sv qemu-system-x86_64 /usr/bin/qemu" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

