#!/bin/sh

. ./_blfsset.sh

APPNAME=pyxdg
VER=0.25
PYVER=2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	python-$PYVER
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Installing
paco -p $TARGET "\
python ./setup.py install --optimize=1" \
	1> $LOG/$TARGET.1_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

