#!/bin/sh

. ./_blfsset.sh

APPNAME=Python
APPVER=3
VER=3.6.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	expat libffi bluez \
	db openssl sqlite tk
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
CXX="/usr/bin/g++" \
./configure --prefix=/usr       \
            --enable-shared     \
$([ ${OPTION_expat} -eq 1 ] && echo --with-system-expat) \
$([ ${OPTION_libffi} -eq 1 ] && echo --with-system-ffi) \
	    --with-ensurepip=yes \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chmod -v 755 /usr/lib/libpython3.6m.so
chmod -v 755 /usr/lib/libpython3.so

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

