#!/bin/sh

. ./_blfsset.sh

APPNAME=poppler
VER=0.67.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	cmake fontconfig
. $WRK/_checkOptions.sh  \
	cairo libjpeg-turbo libpng nss \
	openjpeg curl gtk+-2 \
        lcms-1 lcms2 libtiff libxml2 qt-4
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

mkdir build
cd    build

Configuring
cmake  -DCMAKE_BUILD_TYPE=Release   \
       -DCMAKE_INSTALL_PREFIX=/usr  \
       -DTESTDATADIR=$PWD/testfiles \
       -DENABLE_XPDF_HEADERS=ON     \
       ..                           \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d      /usr/share/doc/poppler-$VER \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m644 README* /usr/share/doc/poppler-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo Extracting encoding data...
tar -xf $DLD/poppler-data-0.4.9.tar.gz \
	1>> $LOG/$TARGET.3_data.log 2>&1 || exit 1

cd poppler-data-0.4.9
porg -lp+ $TARGET "\
make prefix=/usr install" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

