#!/bin/sh

. ./_blfsset.sh

APPNAME=paco
VER=2.0.9
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	bash-completion gtkmm
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $WRK/patch/paco-$VER.patch \
        1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

if [ ${OPTION_gtkmm} -eq 1 ]; then
  export GTKMM=""
else
  export GTKMM="--disable-gpaco"
fi

Configuring
./configure --prefix=/usr --sysconfdir=/etc \
	--enable-scripts \
	$([ ${OPTION_gtkmm} -ne 1 ] && echo --disable-gpaco) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
make install \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo Installing Me...
make logme \
	1> $LOG/$TARGET.4_install.log 2>&1

if [ ${OPTION_bashcompletion} -eq "1" ]; then
  if [ -d /usr/share/bash-completion/completions ]; then
cat >> /usr/share/bash-completion/completions/paco << "EOF"
# Bash completion for paco                                 -*- shell-script -*-

_paco()
{
    local pkgs cur prev words cword
    _init_completion || return

    COMPREPLY=()
    if [ $COMP_CWORD -eq 1 ] && [[ "$cur" != -* ]]; then
        pkgs=$(paco -a1 2>/dev/null)
        COMPREPLY=( $(compgen -W "$pkgs" -- "$cur") )
        return 0
    fi
    _filedir "/var/log/paco/*"

} && complete -F _paco paco

# ex: ts=4 sw=4 et filetype=sh
EOF
    paco -p+ $TARGET "touch /usr/share/bash-completion/completions/paco"
    source /etc/profile
  fi
fi

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

