#!/bin/sh

. ./_blfsset.sh

APPNAME=OpenSP
VER=1.5.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	sgml-common
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i 's:32,:253,:' lib/Syntax.cxx 
sed -i 's:LITLEN          240 :LITLEN          8092:' \
    unicode/{gensyntax.pl,unicode.syn}

Configuring
./configure --prefix=/usr --disable-static --disable-doc-build \
    --enable-default-catalog=/etc/sgml/catalog --enable-http \
    --enable-default-search-path=/usr/share/sgml \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make pkgdatadir=/usr/share/sgml/OpenSP-$VER \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "\
make pkgdatadir=/usr/share/sgml/OpenSP-$VER install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "ln -v -sf onsgmls /usr/bin/nsgmls"
paco -p+ $TARGET "ln -v -sf osgmlnorm /usr/bin/sgmlnorm"
paco -p+ $TARGET "ln -v -sf ospam /usr/bin/spam"
paco -p+ $TARGET "ln -v -sf ospcat /usr/bin/spcat"
paco -p+ $TARGET "ln -v -sf ospent /usr/bin/spent"
paco -p+ $TARGET "ln -v -sf osx /usr/bin/sx"
paco -p+ $TARGET "ln -v -sf osx /usr/bin/sgml2xml"
paco -p+ $TARGET "ln -v -sf libosp.so /usr/lib/libsp.so"

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

