#/bin/sh

VER=182
TARGET=udev-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. ./_blfsset.sh

echo Check Required...
./_checkRequired.sh acl glib-2 gperf pciutils pkg-config usbutils || exit 1
if test "$1" == "check"; then
  exit 0
fi

echo Check Options...
. ./_checkOptions.sh gobject-introspection

if [ ${OPTION_gobjectintrospection} -eq "1" ]; then
  export DISABLEGOBJECTINTROSPECTION=" "
else
  export DISABLEGOBJECTINTROSPECTION="--disable-introspection "
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr                  \
            --sysconfdir=/etc              \
            --sbindir=/sbin                \
            --with-rootlibdir=/lib         \
            --libexecdir=/lib              \
            --with-systemdsystemunitdir=no \
            $DISABLEGOBJECTINTROSPECTION   \
            --docdir=/usr/share/doc/$VER   \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

