#!/bin/sh

. ./_blfsset.sh

VER=0.26
TARGET=pkg-config-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo Check Required...
./_checkRequired.sh glib-2 || exit 1
if test "$1" == "check"; then
  exit 0
fi

#echo Check Options...
#. ./_checkOptions.sh popt

#if [ ${OPTION_popt} -eq "1" ]; then
#  export WITHPOPT="--with-installed-popt "
#else
#  export WITHPOPT=""
#fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

sed -i -e '21s/EXPECT_RETURN=1/EXPECT_RETURN=0/' check/check-cmd-options

echo \ \ Configuring...
GLIB_LIBS=-lglib-2.0  GLIB_CFLAGS=-I/usr/include/glib-2.0  \
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

