#!/bin/sh

. ./_blfsset.sh

VER=1.5.2
TARGET=heimdal-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo Check Required...
./_checkRequired.sh db || exit 1
if test "$1" == "check"; then
  exit 0
fi

echo Check Options...
. ./_checkOptions.sh openldap sqlite libedit

if [ ${OPTION_openldap} -eq "1" ]; then
  export ENABLEOPENLDAP="--with-openldap=/usr --enable-hdb-openldap-module "
else
  export ENABLEOPENLDAP=""
fi

if [ ${OPTION_openldap} -eq "1" ]; then
  export WITHSQLITE="--with-sqlite3=/usr "
else
  export WITHSQLITE=""
fi

if [ ${OPTION_libedit} -eq "1" ]; then
  export WITHLIBEDIT="--with-libedit=/usr "
else
  export WITHLIBEDIT=""
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

#echo \ \ Patching...
#patch -Np1 -i $DLD/heimdal-$VER-otp_fixes-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed -i 's|/var/heimdal|/var/lib/heimdal|' \
       `grep -lr "/var/heimdal" doc kadmin kdc lib`

echo \ \ Configuring...
./configure --prefix=/usr \
            --sysconfdir=/etc/heimdal \
            --libexecdir=/usr/sbin \
            --localstatedir=/var/lib/heimdal \
            --datadir=/var/lib/heimdal \
            --with-hdbdir=/var/lib/heimdal \
            --with-readline=/usr \
            --enable-kcm \
	    $ENABLEOPENLDAP $WITHSQLITE \
	    $WITHLIBEDIT \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Making doc html...
install -v -m755 -d doc/html
mv -v doc/heimdal.html doc/html/heimdal
mv -v doc/hx509.html   doc/html/hx509
makeinfo --html --no-split -o doc/heimdal.html doc/heimdal.texi
makeinfo --html --no-split -o doc/hx509.html   doc/hx509.texi 
makeinfo --plaintext       -o doc/heimdal.txt  doc/heimdal.texi
makeinfo --plaintext       -o doc/hx509.txt    doc/hx509.texi

echo \ \ Installing...
paco -p $TARGET 'make install' \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/heimdal-$VER

paco -p+ $TARGET "\
install -v -m644    doc/{heimdal,hx509}.{html,txt} \
                    doc/{init-creds,layman.asc}    \
                    /usr/share/doc/heimdal-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
cp      -v -R       doc/html \
                    /usr/share/doc/heimdal-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /bin/login          /bin/login.SHADOW &&
mv -v /bin/su             /bin/su.SHADOW    &&
mv -v /usr/bin/{login,su} /bin              &&
ln -v -sf ../../bin/login /usr/bin" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

for LINK in   \
    lib{otp,kafs,krb5,hx509,sqlite3,asn1,roken,crypto,wind}; do
        paco -p+ $TARGET "\
        mv -v     /usr/lib/${LINK}.so.* /lib"
        paco -p+ $TARGET "\
        ln -v -sf ../../lib/$(readlink  /usr/lib/${LINK}.so) \
                  /usr/lib/${LINK}.so"
done

paco -p+ $TARGET "\
mv -v     /usr/lib/$(readlink /usr/lib/libdb.so) \
          /usr/lib/libdb-?.so \
          /lib"

paco -p+ $TARGET "\
ln -v -sf ../../lib/$(readlink /usr/lib/libdb.so) \
          /usr/lib/libdb.so"

ldconfig

paco -p+ $TARGET "\
sed -e 's|/usr/pkg|/usr|' \
    -e 's|/usr/lib/cracklib_dict|/lib/cracklib/pw_dict|' \
    -e 's|/var/heimdal|/var/lib/heimdal|' \
        lib/kadm5/check-cracklib.pl \
     > /bin/krb5-check-cracklib.pl"

chmod -v 755 /bin/krb5-check-cracklib.pl

echo -n \ \ Pacoing:\   && paco -a1 | grep $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

